﻿//デバッグ用
var DBG_PRT = false;
var dbgFlg = 0;

//処理ごとのインデックス【制作中】
var IDX_INIT		= 0;//初期化
var IDX_TITLE		= 1;//タイトル
var IDX_MOVE		= 2;//移動シーン
var IDX_CHANGE		= 3;//場所変更
var IDX_TALK		= 4;//会話
var IDX_TBOX		= 5;//宝箱の処理
var IDX_JOIN		= 6;//仲間になるイベント
var IDX_MENU_TOP	= 7;//メニュー　トップ画面
var IDX_MENU_STS	= 8;//メニュー　能力値
var IDX_MENU_ITM	= 9;//メニュー　アイテム

//変数の宣言
var idx = 0;//┬プログラムの進行を管理
var tmr = 0;//┘
var dcnt = 0;//描画(主にアニメーション)用のカウンター
var gpv = 0;//汎用　その場限りで使う変数

//プレイヤーキャラの移動用
var XP = [ 0,  0, -1,  1];//各向き（上下左右）の座標変化値
var YP = [-1,  1,  0,  0];
var NPC_TALK_DIR = [1, 0, 3, 2];//会話時にＮＰＣをプレイヤーに向かせる
var PLWF = 4;//何フレームで１マス動くか
var plWalk;//移動処理のフラグ（カウンター）
var map_no;//プレイヤーがどのマップにいるか
var worldX, worldY;//プレイヤーのワールドマップ上の座標（町やダンジョンの出入りで使用）

var MENU_TOP = ["能力", "道具", "セーブ", "ロード"];//メニュー画面の項目
var selTtl;//タイトル画面項目選択
var selMenu;//メニュートップ画面項目選択
var selChr;//メニュー能力画面　キャラ選択
var selItm;//メニュー道具画面
var selAns;//はい、いいえを選ぶ

var talkNum;//表示する会話データの番号
var numOfPty;//パーティメンバーが何人いるか

//フラグ管理
var FLG_MAX = 2000;//フラグを全部でいくつ用意するか
var FLG_TBOX =    0;//宝箱用のフラグ(開始番号)
var FLG_JOIN = 1000;//仲間用のフラグ(開始番号)
var flg = [];
function initFlg() {//フラグの初期化
 for(var i = 0; i < FLG_MAX; i++) flg[i] = 0;
}

//入手アイテム管理
var ITM_MAX = 8;
var itm = [];
function initItm() {//フラグの初期化
 for(var i = 0; i < ITM_MAX; i++) itm[i] = 0;
}
function getItm(n, val) {
 itm[n] += val;
 if(itm[n] > 99) {itm[n] = 99; return 1;}
 return 0;
}
function itmName(n) {
 return ITEM_DATA[n*4];
}

//マップデータの管理
var mapdata = [];
var mapname = "";
var mapW, mapH;
var mapAtt = [0, 0, 0, 0, 0];//マップの属性　範囲外は何番のチップにするかなど
var bgmBak = -1;//それまで流していたＢＧＭの番号

function setMap() {//マップデータをセットする
 var mtop = 0;
 var loop = 0;
 while(true) {//データの頭出し
  mapname = MAPDATA[mtop];
  mapW = MAPDATA[mtop+1];
  mapH = MAPDATA[mtop+2];
  if(loop == map_no) break;
  loop ++;
  mtop = mtop + 8 + mapW*mapH;
 }
 for(var i = 0; i < mapW*mapH; i++) mapdata[i] = MAPDATA[mtop+3+i];
 for(var i = 0; i < 5; i++) mapAtt[i] = MAPDATA[mtop+3+mapW*mapH+i];
 if(bgmBak != mapAtt[1]) {//ＢＧＭの番号が変化した場合
  bgmBak = mapAtt[1];
  if(mapAtt[1] >= 0) playBgm(mapAtt[1]); else stopBgm();//出力もしくは停止
 }
}

function chipNo(x, y) {//マップチップの値を返す
 if(x < 0 || x >= mapW || y < 0 || y >= mapH) return mapAtt[0];
 return mapdata[x+y*mapW];
}

function chkWall(cn, dir) {//キャラクターの上下左右が壁か調べる
 var x = obj[cn].x + XP[dir];
 var y = obj[cn].y + YP[dir];
 if( WALL[chipNo(x,y)]&1 == 1 ) return true;//壁
 return false;
}

function drawChip(cn, dx, dy) {//マップチップの表示
 var sx = 1+(CHIP_SIZE+2)*(cn%10);
 var sy = 1+(CHIP_SIZE+2)*(toInt(cn/10));
 drawImgTS(IMG_MAPCHIP, sx, sy, CHIP_SIZE, CHIP_SIZE, dx, dy, CHIP_SIZE, CHIP_SIZE);
}

function drawMS(cn, dx, dy) {//マップシンボルの表示
 var sx = 100*cn;
 var sy = 0;
 drawImgTS(IMG_MAPSYMBOL, sx, sy, 100, 100, dx, dy, 100, 100);
}

function drawChr(cn, dx, dy, dir) {//キャラクターの表示
 var sx = 100*cn+2+48*(toInt(dcnt/4)%2);
 var sy = 72*dir;
 drawImgTS(IMG_HUMAN, sx, sy, 48, 72, dx, dy, 48, 72);
}

//パーティメンバーのステータス(能力)を管理
var PTY_MAX = 10;//パーティメンバーを最大何人管理するか

//ステータスを管理するクラス【開発メモ】将来的に戦闘時の敵の能力も管理する
function Sts(_name, _mh, _str, _def) {//★★★開発中　とりあえず３つ
 this.name = _name;	//名前
 this.mh   = _mh;	//最大体力値
 this.hp   = _mh;	//体力値
 this.str  = _str;	//腕力
 this.def  = _def;	//防御力
}

var sts = [];
function initSts() {//ステータスクラスの初期化
 for(var i = 0; i < PTY_MAX; i++) sts[i] = new Sts("", 0, 0, 0);
}

function setSts(no, _name, _mh, _hp, _str, _def) {
 sts[no].name = _name;
 sts[no].mh   = _mh;
 sts[no].hp   = _hp;
 sts[no].str  = _str;
 sts[no].def  = _def;
}

function setChrSts(no, typ) {//ohq_status.jsで定義してあるパラメータをセットする
 typ *= 6;
 setSts( no,
  CHR_STATUS[typ+0],
  CHR_STATUS[typ+1],
  CHR_STATUS[typ+2],
  CHR_STATUS[typ+3],
  CHR_STATUS[typ+4] );
 return CHR_STATUS[typ+5];//キャラクターの絵の番号を返す
}

//オブジェクトの管理
var OBJ_MAX = 100;//最大いくつのオブジェを管理するか			【開発メモ】0～9の10個はパーティメンバー用
var objMax;//各マップに配置されたオブジェの数					【開発メモ】マップシンボルやNPCは配列10番から配置する
var objNum;//プレイヤーが載った（接した）オブジェクト番号

//Var0.0.5からオブジェクト管理をクラス化する
function Obj(_type, _x, _y, _p, _d1, _d2, _d3, _d4) {
 this.type = _type;			//タイプ　マップシンボルなのか人間なのかなど【開発メモ】値は ohq_mapdata.js で定義している
 this.x = _x;				//┬マップチップ上の座標
 this.y = _y;				//┘
 this.cx = _x*CHIP_SIZE;	//┬キャンバスに表示するための座標
 this.cy = _y*CHIP_SIZE;	//┘
 this.p = _p;				//画像の番号
 this.d1 = _d1;				//各種データ【開発メモ】プレイヤーキャラとＮＰＣの向きは objD1 で管理
 this.d2 = _d2;
 this.d3 = _d3;
 this.d4 = _d4;
}

obj = [];
function initObj() {//オブジェクトクラスの初期化
 for(var i = 0; i < OBJ_MAX; i++) obj[i] = new Obj(0, 0, 0, 0, 0, 0, 0, 0);
 obj[0].type = OBJ_PTY;//★★★開発中　プレイヤーが動かすキャラ
}

function clrObj(n) {//オブジェクトを消す
 obj[n].type = 0;//※この値が0なら存在しないものとする
}

function clrObjAll() {//全てのオブジェクトが配置されていない状態にする
 for(var i = 10; i < OBJ_MAX; i++) clrObj(i);
}

function initLeader() {//パーティメンバー先頭キャラの初期化
 var chrimg = setChrSts(0, 0);//勇者のパラメータをセット
 obj[0].x = 60;
 obj[0].y = 63;
 obj[0].cx = obj[0].x*CHIP_SIZE;
 obj[0].cy = obj[0].y*CHIP_SIZE;
 obj[0].p = chrimg;
 obj[0].d1 = 1;//向き　0上,1下,2左,3右
 numOfPty = 1;
}

function joinPty(stsNo) {//パーティメンバーを加える
 var n = numOfPty;
 var chrimg = setChrSts(n,stsNo);
 obj[n].type = OBJ_PTY;
 obj[n].x = obj[0].x;
 obj[n].y = obj[0].y;
 obj[n].cx = obj[n].x*CHIP_SIZE;
 obj[n].cy = obj[n].y*CHIP_SIZE;
 obj[n].p = chrimg;
 obj[n].d1 = obj[0].d1;
 numOfPty++;//パーティのメンバー数を増やす
}

function walkPty() {//２人目からのパーティメンバーをぞろぞろ歩かせる
 var i, xp, yp;
 for(i = 1; i < 10; i++) {
  if(obj[i].type == OBJ_PTY) {
   xp = obj[i-1].x - obj[i].x;//列の前にいるキャラが何マス離れたか
   yp = obj[i-1].y - obj[i].y;//
   if(Math.abs(xp) >= 2 || Math.abs(yp) >= 2 || xp*yp != 0) {// 横に２マス or 縦に２マス o r斜め に離れた
     obj[i].x = obj[i-1].x - XP[obj[i-1].d1];//すぐ後ろの座標とする
     obj[i].y = obj[i-1].y - YP[obj[i-1].d1];
   }
   //キャンバス上の座標を計算し、必要なら動かす
   xp = obj[i].x*CHIP_SIZE - obj[i].cx;//あるべき位置と現在の位置の差
   yp = obj[i].y*CHIP_SIZE - obj[i].cy;
   var spd = CHIP_SIZE/PLWF;
   if(yp < 0) {obj[i].d1 = 0; obj[i].cy -= spd;}
   if(yp > 0) {obj[i].d1 = 1; obj[i].cy += spd;}
   if(xp < 0) {obj[i].d1 = 2; obj[i].cx -= spd;}
   if(xp > 0) {obj[i].d1 = 3; obj[i].cx += spd;}
  }
 }
}

function gatherPty() {//パーティ全員を先頭キャラの位置にする
 var i;
 for(i = 1; i < 10; i++) {
  obj[i].x  = obj[0].x;
  obj[i].y  = obj[0].y;
  obj[i].cx = obj[i].x*CHIP_SIZE;
  obj[i].cy = obj[i].y*CHIP_SIZE;
  obj[i].d1 = obj[0].d1;
 }
}

function setObj() {//オブジェクトデータをセットする
 var pos = 0;
 var loop = 0;
 while(true) {//データの頭出し
  if(isNaN(OBJDATA[pos]) == true) {
   if(loop == map_no) break;
   loop++;
  }
  pos++;
 }
 pos++
 objMax = 10;
 while(true) {
  if(isNaN(OBJDATA[pos]) == true) break;
console.log("オブジェ配置"+objMax+":"+pos);//★★★デバッグ
  obj[objMax].type = OBJDATA[pos+0];
  obj[objMax].p  = OBJDATA[pos+1];
  obj[objMax].x  = OBJDATA[pos+2];
  obj[objMax].y  = OBJDATA[pos+3];
  obj[objMax].cx = obj[objMax].x*CHIP_SIZE;
  obj[objMax].cy = obj[objMax].y*CHIP_SIZE;
  obj[objMax].d1 = OBJDATA[pos+4];
  obj[objMax].d2 = OBJDATA[pos+5];
  obj[objMax].d3 = OBJDATA[pos+6];
  obj[objMax].d4 = OBJDATA[pos+7];

  //宝箱（入手して空の場合）
  if(_TBOX <= obj[objMax].d2 && obj[objMax].d2 < _TBOX+1000) {
   if(flg[FLG_TBOX+obj[objMax].d2-_TBOX] != 0) obj[objMax].d1 = 1;//宝箱を開いた絵にする
  }
  //配置しないオブジェ
  if(_JOIN <= obj[objMax].d2 && obj[objMax].d2 < _JOIN+1000) {
   if(flg[FLG_JOIN+obj[objMax].d3] != 0) clrObj(objMax);//仲間になったキャラは出現させない
  }

  pos += 10;
  objMax++;
 }
}

function chkSw() {//プレイヤーのいる場所にスイッチがあるか？
 var ret = -1;
 for(var i = 10; i < objMax; i++) {
  if(obj[i].type == OBJ_SW && obj[i].x == obj[0].x && obj[i].y == obj[0].y) {ret = i; break;}
 }
 return ret;
}

function chkObj(dir) {//プレイヤーの目の前にオブジェクトがあるか？
 var ret = -1;
 for(var i = 10; i < objMax; i++) {
//【開発中】現状ＮＰＣと宝箱を判定
  if(obj[i].type == OBJ_NPC || obj[i].type == OBJ_TBOX) {
   if(obj[i].x == obj[0].x+XP[dir] && obj[i].y == obj[0].y+YP[dir]) {ret = i; break;}
  }
 }
 return ret;
}

function drawObj() {//オブジェクトを描画する
 var i, j, n, x, y;
 //表示順番をソート処理で決める
 var sortN = [], sortY = [];
 for(i = 0; i < objMax; i++) {
  sortN[i] = i;
  sortY[i] = obj[i].cy;
  if(obj[i].type == OBJ_PTY) sortY[i] -= i;//パーティメンバーが同じマスにいる時、先頭の勇者が上に表示されるようにする
  if(obj[i].type == OBJ_SW ) sortY[i] -= 1000;//スイッチは強制的に“下側”に表示
 }
 for(i = 0; i < objMax-1; i++) {//バブルソートで並び替える
  for(j = 0; j < objMax-1-i; j++) {
   if(sortY[j] > sortY[j+1]) {
    n = sortN[j]; sortN[j] = sortN[j+1]; sortN[j+1] = n;
    y = sortY[j]; sortY[j] = sortY[j+1]; sortY[j+1] = y;
   }
  }
 }

 for(i = 0; i < objMax; i++) {//表示処理
  n = sortN[i];
  if(obj[n].type == 0) continue;
  x = obj[n].cx-obj[0].cx+(7*CHIP_SIZE);//プレイヤーキャラとの相対座標
  y = obj[n].cy-obj[0].cy+(7*CHIP_SIZE);
  if(obj[n].type == OBJ_PTY || obj[n].type == OBJ_NPC) {
   y -= 32;//足元の位置
   if(-96 < x && x < 720 && -96 < y && y < 720) drawChr(obj[n].p, x, y, obj[n].d1);
  }
  if(obj[n].type == OBJ_SW && obj[n].p >= 0) {//【開発メモ】今のところスイッチはマップシンボルのみ
   x -= ( 100-CHIP_SIZE )/2;//画像のセンタリング
   y -= ( 100-CHIP_SIZE )/2;
   if(-96 < x && x < 720 && -96 < y && y < 720) drawMS(obj[n].p, x, y);
  }
  if(obj[n].type == OBJ_TBOX) {
   if(-96 < x && x < 720 && -96 < y && y < 720) drawImgTS(obj[n].p, 48*obj[n].d1, 0, 48, 48, x, y, 48, 48);
  }
 }
}

//マップ（ＢＧ）の描画
var mapL, mapT, ofsX, ofsY;
function drawBG() {
 var x, y;
 mapL = toInt(obj[0].cx/CHIP_SIZE)-7;
 mapT = toInt(obj[0].cy/CHIP_SIZE)-7;
 ofsX = -(obj[0].cx%CHIP_SIZE);
 ofsY = -(obj[0].cy%CHIP_SIZE);
 for(y = -1; y < 16; y++) {
  for(x = -1; x < 16; x++) drawChip(chipNo(mapL+x,mapT+y), x*CHIP_SIZE+ofsX, y*CHIP_SIZE+ofsY);
 }
}

function drawFG() {
 var c, x, y;
 for(y = 0; y < 17; y++) {
  for(x = -1; x < 16; x++) {
   c = chipNo(mapL+x,mapT+y);
   //フォアとして描画するチップ（屋根のパーツや隠し通路など）
   if( WALL[c] == 2 ) drawChip(c, x*CHIP_SIZE+ofsX, y*CHIP_SIZE+ofsY);
   //上下に並べて表示するチップ
   if( WALL[c] == 3 ) drawChip(c+1, x*CHIP_SIZE+ofsX, (y-1)*CHIP_SIZE+ofsY);
  }
 }
}

//ヴァーチャルキーの表示と入力判定
var vkey = 0;
function virtualKey() {
 vkey = 0;
 if(winW > winH) {
  fRect(720, 0, 240, 720, "#048");
  drawBtn("↑", 840,  90, 240-2, 180-2, 32, "white", 0); if(btn_on[0] > 0) vkey = 38;
  drawBtn("↓", 840, 630, 240-2, 180-2, 32, "white", 1); if(btn_on[1] > 0) vkey = 40;
  drawBtn("←", 780, 360, 120-2, 360-2, 32, "white", 2); if(btn_on[2] > 0) vkey = 37;
  drawBtn("→", 900, 360, 120-2, 360-2, 32, "white", 3); if(btn_on[3] > 0) vkey = 39;
  drawCBtn("[SPC]", 640, 632, 64, 32, "white", 4); if(btn_on[4] > 0) vkey = 32;
 }
 else {
  fRect(0, 720, 720, 240, "#408");
  drawBtn("↑", 360, 780, 360-2, 120-2, 32, "white", 0 ); if( btn_on[0] > 0 ) vkey = 38;
  drawBtn("↓", 360, 900, 360-2, 120-2, 32, "white", 1 ); if( btn_on[1] > 0 ) vkey = 40;
  drawBtn("←",  90, 840, 180-2, 240-2, 32, "white", 2 ); if( btn_on[2] > 0 ) vkey = 37;
  drawBtn("→", 630, 840, 180-2, 240-2, 32, "white", 3 ); if( btn_on[3] > 0 ) vkey = 39;
  drawCBtn("[SPC]", 360, 632, 64, 32, "white", 4); if(btn_on[4] > 0) vkey = 32;
 }
}

function escapeKey() {
 if(winW > winH) {
  drawBtn("[Esc]", 100, 640, 120, 88, 32, "yellow", 6); if(btn_on[6] > 0) vkey = 27;
 }
 else {
  drawBtn("[Esc]", 100, 640, 120, 88, 32, "yellow", 6); if(btn_on[6] > 0) vkey = 27;
 }
}

//ブラウザのサイズが変化した時（スマホなら縦持ち⇔横持ち）
//CWIDTH,CHEIGHT,SCALE,winW,winH変数はシステムで定義されている
function resizeCanvas() {
 var cw, ch;
 if(winW < winH) {//縦長の画面
  CWIDTH = 720;
  CHEIGHT = 960;
  cw = winW;
  ch = winW*CHEIGHT/CWIDTH;
  if(winW/winH > CWIDTH/CHEIGHT) {//縦長ではあるが（正方形に近く）上２行の値では高さが入らない場合
   ch = winH;
   cw = winH*CWIDTH/CHEIGHT;
  }
 }
 else {
  CWIDTH = 960;
  CHEIGHT = 720;
  cw = winH*CWIDTH/CHEIGHT;
  ch = winH;
  if(winW/winH < CWIDTH/CHEIGHT) {//横長ではあるが（正方形に近く）上２行の値では幅が入らない場合
   cw = winW;
   ch = winW*CHEIGHT/CWIDTH;
  }
 }
 cw = toInt(cw);
 ch = toInt(ch);
 SCALE = cw / CWIDTH;
 canvas.width = cw;
 canvas.height = ch;
 bg.scale(SCALE,SCALE);
 bg.textAlign = "center";
 bg.textBaseline = "middle";
}

//メニュー画面の描画用
function drawMenu(x, y, w, h) {
 fRect(x-w/2, y-h/2, w, h, "rgba(0,0,0,0.5)");
 sRect(x-w/2, y-h/2, w, h, "white");
}

//初期化が必要な変数
function initVariable() {
 plWalk = 0;
 map_no = 0;
 selTtl = 0;
 selMenu = 0;
 selChr = 0;
 selItm = 0;
 selAns = 0;
 numOfPty = 0;

 bgmBak = -1;
}

//メイン処理　※メインループはWWSシステムが担っている
function mainProc() {
 var c, i, x, y, w, h;
 tmr++;
 dcnt++;

 switch(idx) {
  case IDX_INIT://初期化処理
  resizeCanvas();
  initVariable();
  initFlg();
  initItm();
  initObj();
  initSts();
  idx = IDX_TITLE;
  break;

  case IDX_TITLE://タイトル画面
  fRect(0, 0, 720, 720, "white");
  drawImg(IMG_TITLE, 60, 60);
  virtualKey();
  if(inkey == 38 || vkey == 38) selTtl = 0;
  if(inkey == 40 || vkey == 40) selTtl = 1;
  drawBtn("ＢＧＭあり", 360, 410, 240, 60, 40, (selTtl==0)?"-cyan":"-gray", 10); if(btn_on[10] == 1) selTtl = 0;
  drawBtn("ＢＧＭ無し", 360, 510, 240, 60, 40, (selTtl==1)?"-cyan":"-gray", 11); if(btn_on[11] == 1) selTtl = 1;
  if(key[32] == 1 || btn_on[4] == 1 || btn_on[10] > 1 || btn_on[11] > 1) {
   if(selTtl == 0) SOUND_ON = true;
   if(selTtl == 1) SOUND_ON = false;
   initLeader();
   setMap();
   setObj();
   idx = IDX_MOVE;
  }
  break;

  case IDX_MOVE://プレイヤーキャラの移動
  drawBG();
  drawObj();
  drawFG();
  virtualKey();
  walkPty();//パーティメンバーをぞろぞろ引き連れて歩く処理
  if(plWalk == 0) {//停止中
   obj[0].cx = obj[0].x*CHIP_SIZE;
   obj[0].cy = obj[0].y*CHIP_SIZE;
   objNum = chkSw();
   if(objNum >= 10) {//町やダンジョンに入る
    idx = IDX_CHANGE;
    tmr = 0;
    break;
   }
   if(obj[0].x < 0 || obj[0].x >= mapW || obj[0].y < 0 || obj[0].y >= mapH) {//ワールドマップに戻る
    objNum = 0;//ワールドマップに戻るフラグとして使用
    idx = IDX_CHANGE;
    tmr = 0;
    break;
   }
   if(     inkey == 38 || vkey == 38) {obj[0].d1 = 0; if(chkWall(0,obj[0].d1) == false && chkObj(obj[0].d1) == -1) {obj[0].y--; plWalk = 1;} }
   else if(inkey == 40 || vkey == 40) {obj[0].d1 = 1; if(chkWall(0,obj[0].d1) == false && chkObj(obj[0].d1) == -1) {obj[0].y++; plWalk = 1;} }
   else if(inkey == 37 || vkey == 37) {obj[0].d1 = 2; if(chkWall(0,obj[0].d1) == false && chkObj(obj[0].d1) == -1) {obj[0].x--; plWalk = 1;} }
   else if(inkey == 39 || vkey == 39) {obj[0].d1 = 3; if(chkWall(0,obj[0].d1) == false && chkObj(obj[0].d1) == -1) {obj[0].x++; plWalk = 1;} }
   else if(key[32] == 1 || btn_on[4] == 1) {//【制作中】調べる、メニューを開く
    objNum = chkObj(obj[0].d1);
    if(objNum >= 10) {//目の前に何かある
     if(obj[objNum].type == OBJ_NPC) {
      obj[objNum].d1 = NPC_TALK_DIR[obj[0].d1];//プレイヤーの方に向かせる
      if(_TALK <= obj[objNum].d2 && obj[objNum].d2 < _TALK+1000) {
       talkNum = obj[objNum].d2;
       idx = IDX_TALK;
       break;
      }
      if(_JOIN <= obj[objNum].d2 && obj[objNum].d2 < _JOIN+1000) {
       talkNum = obj[objNum].d2 - _JOIN;
       idx = IDX_JOIN;
       break;
      }
     }
     else if(obj[objNum].type == OBJ_TBOX) {
      if(_TBOX <= obj[objNum].d2 && obj[objNum].d2 < _TBOX+1000) {
       if(flg[FLG_TBOX+obj[objNum].d2-_TBOX] == 0) {//まだ開けていない
        gpv = obj[objNum].d3;//中身（アイテムの番号）
        obj[objNum].d1 = 1;//宝箱を開いた絵にする
        idx = IDX_TBOX;
        break;
       }
      }
     }
    }
    //イベントが無ければメニューを開く
    idx = IDX_MENU_TOP;
   }
  }
  else {//移動中
   obj[0].cx = (obj[0].x-XP[obj[0].d1])*CHIP_SIZE + XP[obj[0].d1]*CHIP_SIZE*plWalk/PLWF;
   obj[0].cy = (obj[0].y-YP[obj[0].d1])*CHIP_SIZE + YP[obj[0].d1]*CHIP_SIZE*plWalk/PLWF;
   plWalk ++;
   if(plWalk >= PLWF) plWalk = 0;
  }
  break;

  case IDX_CHANGE://マップ切り替え
  drawBG();
  drawObj();
  drawFG();
  virtualKey();
  if(tmr == 1) {
   if(map_no == 0) {worldX = obj[0].x; worldY = obj[0].y;}
  }
  if(tmr <= 20) fRect(0, 0, CHIP_SIZE*15, CHIP_SIZE*15, "rgba(0,0,0,"+0.05*tmr+")");
  if(tmr >  20) fRect(0, 0, CHIP_SIZE*15, CHIP_SIZE*15, "rgba(0,0,0,"+0.05*(40-tmr)+")");
  if(tmr == 20) {
   if(objNum == 0) {//ワールドマップに戻る
    obj[0].x = worldX;
    obj[0].y = worldY+1;
    obj[0].d1 = 1;
    map_no = 0;
   }
   else {//町やダンジョンへ、及び、階層移動
    map_no    = obj[objNum].d1;
    obj[0].x  = obj[objNum].d2;
    obj[0].y  = obj[objNum].d3;
    obj[0].d1 = obj[objNum].d4;
   }
   obj[0].cx = obj[0].x*CHIP_SIZE;
   obj[0].cy = obj[0].y*CHIP_SIZE;
   gatherPty();
   clrObjAll();
   setObj();
   setMap();
  }
  if(tmr == 40) idx = IDX_MOVE;
  break;

  case IDX_TBOX://宝箱
  drawBG();
  drawObj();
  drawFG();
  virtualKey();
  x = 360;
  y = 440;
  w = 680;
  h = 180;
  fRect(x-w/2, y-h/2, w, h, "rgba(0,0,0,0.5)");
  sRect(x-w/2, y-h/2, w, h, "white");
  fMessage("入手アイテム　" + itmName(gpv), x-w/2+20, y-h/2+30, 60, 36, "white");
  if(key[32] == 1 || btn_on[4] == 1) {
   getItm(gpv, 1);
   flg[FLG_TBOX+obj[objNum].d2-_TBOX] = 1;
   idx = IDX_MOVE;
  }
  break;

  case IDX_TALK://会話
  case IDX_JOIN://仲間になる
  drawBG();
  drawObj();
  drawFG();
  virtualKey();
  x = 360;
  y = 440;
  w = 680;
  h = 180;
  fRect(x-w/2, y-h/2, w, h, "rgba(0,0,0,0.5)");
  sRect(x-w/2, y-h/2, w, h, "white");
  fMessage(TALK_DATA[talkNum], x-w/2+20, y-h/2+30, 60, 36, "white");
  if(idx == IDX_TALK) {//会話だけの処理
   if(key[32] == 1 || btn_on[4] == 1) idx = IDX_MOVE;
  }
  if(idx == IDX_JOIN) {//仲間になるイベントの処理
   x = 620;
   y = 120;
   w = 160;
   h = 160;
   fRect(x-w/2, y-h/2, w, h, "rgba(0,0,0,0.5)");
   sRect(x-w/2, y-h/2, w, h, "white");
   drawBtn("はい",   x, y-40, 80, 60, 32, (selAns==0)?"-cyan":"-silver", 10); if(btn_on[10] == 1) selAns = 0;
   drawBtn("いいえ", x, y+40, 80, 60, 32, (selAns==1)?"-cyan":"-silver", 11); if(btn_on[11] == 1) selAns = 1;
   if(inkey == 38 || vkey == 38) selAns = 0;
   if(inkey == 40 || vkey == 40) selAns = 1;
   if(key[32] == 1 || btn_on[4] == 1 || btn_on[10] > 1 || btn_on[11] > 1) {
    if(selAns == 0) {//仲間にする
      joinPty(obj[objNum].d3);//オブジェクラスのd3に誰が仲間になるか（ステータスの番号）が入っている
      flg[FLG_JOIN+obj[objNum].d3] = 1;//フラグを立てる
      clrObj(objNum);
      talkNum++;
      idx = IDX_TALK;
    }
    else {
     idx = IDX_MOVE;
    }
   }
  }
  break;

  case IDX_MENU_TOP://メニュートップ画面
  drawBG();
  drawObj();
  drawFG();
  virtualKey();
  escapeKey();
  x = 360;
  y = 320;
  w = 640;
  h = 360;
  drawMenu(x, y, w, h);
  for(i = 0; i < 4; i++) {
   var mx = i%2;
   var my = toInt(i/2);
   drawBtn(MENU_TOP[i], x+(mx*2-1)*120, y+(my*2-1)*80, 80, 60, 32, (selMenu==i)?"-cyan":"-silver", 10+i);
   if(btn_on[10+i] == 1 || btn_on[10+i] == 6) {//タップ時、長押し時の両方で判断しスマートデバイスらしい操作感を実現
    if(selMenu == i) {
     if(selMenu == 0) idx = IDX_MENU_STS;
     if(selMenu == 1) idx = IDX_MENU_ITM;
    }
    else {
     selMenu = i;
    }
   }
  }
//【制作中】仮のメニュー項目選択
//  if(inkey == 38 || vkey == 38)
//  if(inkey == 40 || vkey == 40)
  if(key[38] == 1 || btn_on[0] == 1) if(selMenu >= 2) selMenu -= 2;
  if(key[40] == 1 || btn_on[1] == 1) if(selMenu <= 1) selMenu += 2;

  if(inkey == 37 || vkey == 37) selMenu -= selMenu%2;
  if(inkey == 39 || vkey == 39) selMenu += (selMenu+1)%2;
  if(key[32] == 1 || btn_on[4] == 1) {
   if(selMenu == 0) idx = IDX_MENU_STS;
   if(selMenu == 1) idx = IDX_MENU_ITM;
  }
  if(key[27] == 1 || btn_on[6] == 1) idx = IDX_MOVE;
  break;

  case IDX_MENU_STS://メニュー能力画面
  drawBG();
  drawObj();
  drawFG();
  virtualKey();
  escapeKey();
  x = 360;
  y = 320;
  w = 640;
  h = 360;
  drawMenu(x, y, w, h);
//【制作中】仮
  y -= h/2;
  y += 60;
  fText(sts[selChr].name, x-80, y, 32, "white");
  if(numOfPty >= 2) {//パーティメンバーが２人以上いる時
   fText("←", x-80-80, y, 32, "white");
   fText("→", x-80+80, y, 32, "white");
  }
  y += 60;
  fText("MH",  x-80, y, 32, "white"); fText(sts[selChr].mh,  x+80, y, 32, "white");
  y += 60;
  fText("HP",  x-80, y, 32, "white"); fText(sts[selChr].hp,  x+80, y, 32, "white");
  y += 60;
  fText("STR", x-80, y, 32, "white"); fText(sts[selChr].str, x+80, y, 32, "white");
  y += 60;
  fText("DEF", x-80, y, 32, "white"); fText(sts[selChr].def, x+80, y, 32, "white");
  if(numOfPty >= 2) {
   if(key[37] == 1 || btn_on[2] == 1) {selChr --; if(selChr < 0) selChr = numOfPty-1;}
   if(key[39] == 1 || btn_on[3] == 1) {selChr ++; if(selChr > numOfPty-1) selChr = 0;}
  }
  if(key[27] == 1 || btn_on[6] == 1) idx = IDX_MENU_TOP;
  break;

  case IDX_MENU_ITM://メニューアイテム画面
  drawBG();
  drawObj();
  drawFG();
  virtualKey();
  escapeKey();
  x = 360;
  y = 320;
  w = 640;
  h = 360;
  drawMenu(x, y, w, h);
  y = y - h/2 + 40;
  for(i = 0; i < ITM_MAX; i ++) {
   if(itm[i] > 0) {
    fText(itmName(i), x, y, 32, "white");
    if(itm[i] > 1) fText("x"+itm[i], x+160, y, 32, "white");
   }
   else {
    fText("--------", x, y, 32, "silver");
   }
   if(selItm == i) fRect(x-80, y-12, 160, 24, "rgba(255,255,255,0.3)");
   y += 40;
  }
  if(key[38] == 1 || key[38] > 5 || btn_on[0] == 1 || btn_on[0] > 5) {selItm --; if(selItm < 0) selItm = ITM_MAX-1;}
  if(key[40] == 1 || key[40] > 5 || btn_on[1] == 1 || btn_on[1] > 5) {selItm ++; if(selItm > ITM_MAX-1) selItm = 0;}
  if(key[27] == 1 || btn_on[6] == 1) idx = IDX_MENU_TOP;
  break;

 }

//★★★デバッグ　フラグの値を表示する
if( DBG_PRT ) {//★★★デバッグ

if(idx==IDX_MENU_TOP) {
 if(inkey == 65) {dbgFlg-=20; if(dbgFlg<0)dbgFlg=FLG_MAX-20; }
 if(inkey == 90) {dbgFlg+=20; if(dbgFlg>=FLG_MAX-20)dbgFlg=0; }
 fRect(20, 20, 680, 100, "rgba(0,0,0,0.5)");
 for(y=0;y<5;y++){
  fText((dbgFlg+y*20)%FLG_MAX, 40, 30+20*y, 14, "lime");
  for(x=0;x<20;x++){
  i=(dbgFlg+x+y*20)%FLG_MAX;
  fText(flg[i],70+32*x,30+20*y,12,(flg[i]==1)?"red":"white");
  }
 }
} else {
 fText( mapname, 100, 30, 24, "white" );
 fText( "X="+obj[0].x+" Y="+obj[0].y+" D="+obj[0].d1+" map_no="+map_no, 400, 30, 24, "white" );
 fText( ""+idx+":"+tmr, 100, 60, 24, "cyan" );
 fText( "inkey="+inkey+" vkey="+vkey, 400, 90, 24, "yellow" );
 fText( "CX="+obj[0].cx+" CY="+obj[0].cy+" plWalk="+plWalk, 400, 60, 24, "white" );
// fText( "bgmBak="+bgmBak+" BGM番号="+mapAtt[1], 400, 120, 24, "cyan" );
// fText( "key[32]="+key[32]+" btn_on[4]="+btn_on[4], 400, 150, 24, "pink" );
 if( plWalk == 0 ) fText( chkObj(), 680, 30, 24, "yellow" );
}

}

 //ブラウザのサイズが変化したか？（スマホなら持ち方を変えたか　縦持ち⇔横持ち）
 w = window.innerWidth;
 h = window.innerHeight;
 if(winW != w || winH != h) {
  winW = w;
  winH = h;
  resizeCanvas();
 }

}

//【メモ】メイン処理と描画処理を分ける場合、描画処理をここに記載
function drawProc() {}
