// ---------- 汎用ボタンサンプル ----------
// ボタンの形状や色などを必要に応じて書き替えます
// btn_on[n] の値がマイナスになった時が、押して指を放したタイミング
// ----------------------------------------

var BTN_MAX = 100;
var btn_in = new Array(BTN_MAX);//マウスorタップがボタン内にある
var btn_on = new Array(BTN_MAX);//そこを押された→カウントアップ／押して放した瞬間→値をマイナスに

//判定用のフラグをクリアする
function clrBtn() {
	for( var i = 0; i < BTN_MAX; i ++ ) {
		btn_in[i] = 0;
		btn_on[i] = 0;
	}
}

//colを-1で指定すると描画しない
function drawBtn( str, x, y, w, h, siz, col, bno ) {//長方形のボタン
	var fc = "rgba(128,128,128,0.5)";
	w -= 2;//【開発メモ】線のサイズをlineW(4)にしているので画面端に置くボタンの線が消えないように
	h -= 2;//
	x -= w/2;
	y -= h/2;
	if( x < tapX && tapX < x+w && y < tapY && tapY < y+h ) {
		fc = "rgba(255,255,255,0.5)";
		btn_in[bno] = 1;
		if( tapC > 0 ) {
			fc = "rgba(255,255,255,0.8)";
			btn_on[bno] ++;
		}
		else {
			if( btn_on[bno] > 0 )
				btn_on[bno] = -btn_on[bno];
			else
				btn_on[bno] = 0;
		}
	}
	else {
		btn_in[bno] = 0;
		btn_on[bno] = 0;
	}
	
	var r = 4;
	var deg90 = Math.PI/2;
	lineW(4);
	bg.beginPath();
	bg.moveTo( x, y+h-r );
	bg.arc( x+r, y+r, r, deg90*2, deg90*3, false );
	bg.lineTo( x+w-r, y );
	bg.arc( x+w-r, y+r, r, deg90*3, deg90*4, false );
	bg.lineTo( x+w, y+h-r );
	bg.arc( x+w-r, y+h-r, r, 0, deg90, false );
	bg.lineTo( x+r, y+h );
	bg.arc( x+r, y+h-r, r, deg90, deg90*2, false );
	bg.closePath();
	if( col.substring(0,1) != "-" ) {
		bg.fillStyle = fc;
		bg.fill();
		bg.strokeStyle = "#fff";
		bg.stroke();
	}
	else {
		col = col.slice(1);
	}
	fText( str, x+w/2, y+h/2+1, siz, col );
	fText( str, x+w/2, y+h/2,   siz, col );
}

function drawCBtn( str, x, y, r, siz, col, bno ) {//円のボタン
	var fc = "rgba(128,128,128,0.5)";
	if( (x-tapX)*(x-tapX)+(y-tapY)*(y-tapY) < r*r ) {
		fc = "rgba(255,255,255,0.5)";
		btn_in[bno] = 1;
		if( tapC > 0 ) {
			fc = "rgba(255,255,255,0.8)";
			btn_on[bno] ++;
		}
		else {
			if( btn_on[bno] > 0 )
				btn_on[bno] = -btn_on[bno];
			else
				btn_on[bno] = 0;
		}
	}
	else {
		btn_in[bno] = 0;
		btn_on[bno] = 0;
	}
	
	lineW(4);
	bg.beginPath();
	bg.arc( x, y, r, 0, Math.PI*2, false );
	bg.closePath();
	if( col.substring(0,1) != "-" ) {
		bg.fillStyle = fc;
		bg.fill();
		bg.strokeStyle = "#fff";
		bg.stroke();
	}
	else {
		col = col.slice(1);
	}
	fText( str, x, y+1, siz, col );
	fText( str, x, y,   siz, col );

}
