﻿//デバッグ用
var DBG_PRT = false;

//処理ごとのインデックス【制作中】
var IDX_INIT		= 0;//初期化
var IDX_TITLE		= 1;//タイトル
var IDX_MOVE		= 2;//移動シーン
var IDX_CHANGE		= 3;//場所変更
var IDX_TALK		= 4;//会話
var IDX_MENU_TOP	= 5;//メニュー　トップ画面
var IDX_MENU_STS	= 6;//メニュー　能力値

//変数の宣言
var idx = 0;//┬プログラムの進行を管理
var tmr = 0;//┘
var dcnt = 0;//描画(主にアニメーション)用のカウンター

//プレイヤーキャラの移動用
var XP = [  0,  0, -1,  1 ];//各向き（上下左右）の座標変化値
var YP = [ -1,  1,  0,  0 ];
var NPC_TALK_DIR = [ 1, 0, 3, 2 ];//会話時にＮＰＣをプレイヤーに向かせる
var PLWF = 4;//何フレームで１マス動くか
var plWalk = 0;//移動処理のフラグ（カウンター）
var map_no = 0;//プレイヤーがどのマップにいるか
var worldX, worldY;//プレイヤーのワールドマップ上の座標（町やダンジョンの出入りで使用）

var MENU_TOP = [ "能力", "道具", "セーブ", "ロード" ];//メニュー画面の項目
var selMenu = 0;//メニュートップ画面項目選択
var selChar = 0;//メニュー能力画面キャラクター選択

//マップデータの管理
var mapdata = [];
var mapname = "";
var mapW, mapH;
var mapAtt = [ 0, 0, 0, 0, 0 ];//マップの属性　範囲外は何番のチップにするかなど
var bgmBak = -1;//それまで流していたＢＧＭの番号

function setMap() {//マップデータをセットする
 var mtop = 0;
 var loop = 0;
 while( true ) {//データの頭出し
  mapname = MAPDATA[mtop];
  mapW = MAPDATA[mtop+1];
  mapH = MAPDATA[mtop+2];
  if( loop == map_no ) break;
  loop ++;
  mtop = mtop + 8 + mapW*mapH;
 }
 for( var i = 0; i < mapW*mapH; i ++ ) mapdata[i] = MAPDATA[mtop+3+i];
 for( var i = 0; i < 5; i ++ ) mapAtt[i] = MAPDATA[mtop+3+mapW*mapH+i];
 if( bgmBak != mapAtt[1] ) {//ＢＧＭの番号が変化した場合
  bgmBak = mapAtt[1];
  if( mapAtt[1] >= 0 ) playBgm(mapAtt[1]); else stopBgm();//出力もしくは停止
 }
}

function chipNo( x, y ) {//マップチップの値を返す
 if( x < 0 || x >= mapW || y < 0 || y >= mapH ) return mapAtt[0];
 return mapdata[x+y*mapW];
}

function drawChip( cn, dx, dy ) {//マップチップを表示
 var sx = 1+(CHIP_SIZE+2)*(cn%10);
 var sy = 1+(CHIP_SIZE+2)*(toInt(cn/10));
 drawImgTS( IMG_MAPCHIP, sx, sy, CHIP_SIZE, CHIP_SIZE, dx, dy, CHIP_SIZE, CHIP_SIZE );
}

function drawMS( cn, dx, dy ) {//マップシンボルを表示
 var sx = 100*cn;
 var sy = 0;
 drawImgTS( IMG_MAPSYMBOL, sx, sy, 100, 100, dx, dy, 100, 100 );
}

//パーティメンバーのステータス(能力)を管理
var PTY_MAX = 10;//パーティメンバーを最大何人管理するか
var ptyMax = 1;//現在パーティに何人加わっているか

//ステータスを管理するクラス【開発メモ】将来的に戦闘時の敵の能力も管理する
function Sts( _mh, _str, _def ) {//★★★開発中　とりあえず３つ
 this.mh = _mh;		//最大体力値
 this.hp = _mh;		//体力値
 this.str = _str;	//腕力
 this.def = _def;	//防御力
}

var sts = [];
function initSts() {//ステータスクラスの初期化
 for( var i = 0; i < PTY_MAX; i ++ ) sts[i] = new Sts( 0, 0, 0 );
}

function setSts( no, _mh, _str, _def ) {
 sts[no].mh  = _mh;
 sts[no].hp  = _mh;
 sts[no].str = _str;
 sts[no].def = _def;
}

//オブジェクトの管理
var OBJ_MAX = 100;//最大いくつのオブジェを管理するか			【開発メモ】0～9の10個はパーティメンバー用
var objMax;//各マップに配置されたオブジェの数					【開発メモ】マップシンボルやNPCは配列10番から配置する
var objNum;//プレイヤーが載った（接した）オブジェクト番号

//Var0.0.5からオブジェクト管理をクラス化する
function Obj( _type, _x, _y, _p, _d1, _d2, _d3, _d4 ) {
 this.type = _type;			//タイプ　マップシンボルなのか人間なのかなど【開発メモ】値は ohq_mapdata.js で定義している
 this.x = _x;				//┬マップチップ上の座標
 this.y = _y;				//┘
 this.cx = _x*CHIP_SIZE;	//┬キャンバスに表示するための座標
 this.cy = _y*CHIP_SIZE;	//┘
 this.p = _p;				//画像の番号
 this.d1 = _d1;				//各種データ【開発メモ】プレイヤーキャラとＮＰＣの向きは objD1 で管理
 this.d2 = _d2;
 this.d3 = _d3;
 this.d4 = _d4;
}

obj = [];
function initObj() {//オブジェクトクラスの初期化
 for( var i = 0; i < OBJ_MAX; i ++ ) obj[i] = new Obj( 0, 0, 0, 0, 0, 0, 0, 0 );
 obj[0].type = OBJ_PTY;//★★★開発中　プレイヤーが動かすキャラ
}

function clrObj() {//オブジェクトが配置されていない状態にする
 for( var i = 10; i < OBJ_MAX; i ++ ) obj[i].type = 0;//※この値が0なら存在しないものとする
}

function initPty() {//パーティメンバーの変数の初期値
 obj[0].x = 10;
 obj[0].y = 10;
 obj[0].cx = obj[0].x*CHIP_SIZE;
 obj[0].cy = obj[0].y*CHIP_SIZE;
 obj[0].p = IMG_HUMAN;
 obj[0].di = 1;//向き　0上,1下,2左,3右
 map_no = 0;
 plWalk = 0;
}

function setObj() {//オブジェクトデータをセットする
 var pos = 0;
 var loop = 0;
 while( true ) {//データの頭出し
  if( isNaN(OBJDATA[pos]) == true ) {
   if( loop == map_no ) break;
   loop ++;
  }
  pos ++;
 }
 pos ++
 objMax = 10;
 while( true ) {
  if( isNaN(OBJDATA[pos]) == true ) break;
console.log("オブジェ配置"+objMax+":"+pos);//★★★デバッグ
  obj[objMax].type  = OBJDATA[pos+0];
  obj[objMax].p  = OBJDATA[pos+1];
  obj[objMax].x  = OBJDATA[pos+2];
  obj[objMax].y  = OBJDATA[pos+3];
  obj[objMax].cx = obj[objMax].x*CHIP_SIZE;
  obj[objMax].cy = obj[objMax].y*CHIP_SIZE;
  obj[objMax].d1 = OBJDATA[pos+4];
  obj[objMax].d2 = OBJDATA[pos+5];
  obj[objMax].d3 = OBJDATA[pos+6];
  obj[objMax].d4 = OBJDATA[pos+7];
  pos += 10;
  objMax ++;
 }
}

function chkSw() {//プレイヤーのいる場所にスイッチがあるか？
 var ret = -1;
 for( var i = 10; i < objMax; i ++ ) {
  if( obj[i].type == OBJ_SW && obj[i].x == obj[0].x && obj[i].y == obj[0].y ) { ret = i; break; }
 }
 return ret;
}

function chkObj( dir ) {//プレイヤーの目の前にオブジェクトがあるか？
 var ret = -1;
 for( var i = 10; i < objMax; i ++ ) {
//【開発中】現状ＮＰＣだけ判定
  if( obj[i].type == OBJ_NPC && obj[i].x == obj[0].x+XP[dir] && obj[i].y == obj[0].y+YP[dir] ) { ret = i; break; }
 }
 return ret;
}

function drawChr( cn, dx, dy, dir ) {//キャラクターの表示
 var sx = 48*(toInt(dcnt/4)%2);
 var sy = 72*dir;
 drawImgTS( cn, sx, sy, 48, 72, dx, dy, 48, 72 );
}

function drawObj() {//オブジェクトを描画する
 var i, j, n, x, y;
 //表示順番をソート処理で決める
 var sortN = [], sortY = [];
 for( i = 0; i < objMax; i ++ ) {
  sortN[i] = i;
  sortY[i] = obj[i].cy;
  if( obj[i].type == OBJ_SW ) sortY[i] -= 1000;//スイッチは強制的に“下側”に表示
 }
 for( i = 0; i < objMax-1; i ++ ) {//バブルソートで並び替える
  for( j = 0; j < objMax-1-i; j ++ ) {
   if( sortY[j] > sortY[j+1] ) {
    n = sortN[j]; sortN[j] = sortN[j+1]; sortN[j+1] = n;
    y = sortY[j]; sortY[j] = sortY[j+1]; sortY[j+1] = y;
   }
  }
 }

 for( i = 0; i < objMax; i ++ ) {//表示処理
  n = sortN[i];
  if( obj[n].type == 0 ) continue;
  x = obj[n].cx-obj[0].cx+(7*CHIP_SIZE);//プレイヤーキャラとの相対座標
  y = obj[n].cy-obj[0].cy+(7*CHIP_SIZE);
  if( obj[n].type == OBJ_PTY || obj[n].type == OBJ_NPC ) {
   y -= 32;//足元の位置
   if( -96 < x && x < 720 && -96 < y && y < 720 ) drawChr( obj[n].p, x, y, obj[n].d1 );
  }
  if( obj[n].type == OBJ_SW ) {//【開発メモ】今のところスイッチはマップシンボルのみ
   x -= ( 100-CHIP_SIZE )/2;//画像のセンタリング
   y -= ( 100-CHIP_SIZE )/2;
   if( -96 < x && x < 720 && -96 < y && y < 720 ) drawMS( obj[n].p, x, y );
  }
 }
}

//マップ（ＢＧ）の描画
var mapL, mapT, ofsX, ofsY;
function drawBG() {
 var x, y;
 mapL = toInt(obj[0].cx/CHIP_SIZE)-7;
 mapT = toInt(obj[0].cy/CHIP_SIZE)-7;
 ofsX = -(obj[0].cx%CHIP_SIZE);
 ofsY = -(obj[0].cy%CHIP_SIZE);
 for( y = -1; y < 16; y ++ ) {
  for( x = -1; x < 16; x ++ ) drawChip( chipNo(mapL+x,mapT+y), x*CHIP_SIZE+ofsX, y*CHIP_SIZE+ofsY );
 }
}

//ヴァーチャルキーの表示と入力判定
var vkey = 0;
function virtualKey() {
 vkey = 0;
 if( winW > winH ) {
  fRect( 720, 0, 240, 720, "#048" );
  drawBtn( "↑", 840,  90, 240-2, 180-2, 32, "white", 0 ); if( btn_on[0] > 0 ) vkey = 38;
  drawBtn( "↓", 840, 630, 240-2, 180-2, 32, "white", 1 ); if( btn_on[1] > 0 ) vkey = 40;
  drawBtn( "←", 780, 360, 120-2, 360-2, 32, "white", 2 ); if( btn_on[2] > 0 ) vkey = 37;
  drawBtn( "→", 900, 360, 120-2, 360-2, 32, "white", 3 ); if( btn_on[3] > 0 ) vkey = 39;
  drawCBtn( "[SPC]", 640, 640, 60, 32, "white", 4 ); if( btn_on[4] == 1 ) vkey = 32;
  drawBtn( "[S]ound " + (SOUND_ON?"OFF":"ON"), 640, 60, 144, 48, 20, "cyan", 5 ); if( btn_on[5] == 1 ) vkey = 83;
 }
 else {
  fRect( 0, 720, 720, 240, "#408" );
  drawBtn( "↑", 360, 780, 360-2, 120-2, 32, "white", 0 ); if( btn_on[0] > 0 ) vkey = 38;
  drawBtn( "↓", 360, 900, 360-2, 120-2, 32, "white", 1 ); if( btn_on[1] > 0 ) vkey = 40;
  drawBtn( "←",  90, 840, 180-2, 240-2, 32, "white", 2 ); if( btn_on[2] > 0 ) vkey = 37;
  drawBtn( "→", 630, 840, 180-2, 240-2, 32, "white", 3 ); if( btn_on[3] > 0 ) vkey = 39;
  drawCBtn( "[SPC]", 360, 640, 60, 32, "white", 4 ); if( btn_on[4] == 1 ) vkey = 32;
  drawBtn( "[S]ound " + (SOUND_ON?"OFF":"ON"), 640, 60, 144, 48, 20, "cyan", 5 ); if( btn_on[5] == 1 ) vkey = 83;
 }
}

function escapeKey() {
 if( winW > winH ) {
  drawBtn( "[Esc]", 100, 640, 100, 80, 32, "yellow", 6 ); if( btn_on[6] == 1 ) vkey = 27;
 }
 else {
  drawBtn( "[Esc]", 100, 640, 100, 80, 32, "yellow", 6 ); if( btn_on[6] == 1 ) vkey = 27;
 }
}

//ブラウザのサイズが変化した時（スマホなら縦持ち⇔横持ち）
//CWIDTH,CHEIGHT,SCALE,winW,winH変数はシステムで定義されている
function resizeCanvas() {
 var cw, ch;
 if( winW < winH ) {//縦長の画面
  CWIDTH = 720;
  CHEIGHT = 960;
  cw = winW;
  ch = winW*CHEIGHT/CWIDTH;
  if( winW/winH > CWIDTH/CHEIGHT ) {//縦長ではあるが（正方形に近く）上２行の値では高さが入らない場合
   ch = winH;
   cw = winH*CWIDTH/CHEIGHT;
  }
 }
 else {
  CWIDTH = 960;
  CHEIGHT = 720;
  cw = winH*CWIDTH/CHEIGHT;
  ch = winH;
  if( winW/winH < CWIDTH/CHEIGHT ) {//横長ではあるが（正方形に近く）上２行の値では幅が入らない場合
   cw = winW;
   ch = winW*CHEIGHT/CWIDTH;
  }
 }
 cw = toInt(cw);
 ch = toInt(ch);
 SCALE = cw / CWIDTH;
 canvas.width = cw;
 canvas.height = ch;
 bg.scale(SCALE,SCALE);
 bg.textAlign = "center";
 bg.textBaseline = "middle";
}

//メイン処理　※メインループはWWSシステムが担っている
function mainProc() {
 var c, i, x, y, w, h;
 tmr ++;
 dcnt ++;

 switch( idx ) {
  case IDX_INIT://初期化処理
  resizeCanvas();
  initObj();
  initPty();
  initSts();
  setMap();
  setObj();
  idx = IDX_TITLE;
  break;

  case IDX_TITLE://タイトル画面
  idx = IDX_MOVE;//【開発中】未実装、飛ばして移動シーンへ
  break;

  case IDX_MOVE://プレイヤーキャラの移動
  drawBG();
  drawObj();
  virtualKey();
  if( plWalk == 0 ) {//停止中
   obj[0].cx = obj[0].x*CHIP_SIZE;
   obj[0].cy = obj[0].y*CHIP_SIZE;
   objNum = chkSw();
   if( objNum >= 10 ) {//町やダンジョンに入る
    idx = IDX_CHANGE;
    tmr = 0;
    break;
   }
   if( obj[0].x < 0 || obj[0].x >= mapW || obj[0].y < 0 || obj[0].y >= mapH ) {//ワールドマップに戻る
    idx = IDX_CHANGE;
    tmr = 0;
    break;
   }

if( key[83] == 1 || vkey == 83 ) {//★★★サウンド仮実装
 if( SOUND_ON == false ) {
  SOUND_ON = true;
  if( mapAtt[1] >= 0 ) playBgm(mapAtt[1]);
 }
 else {
  SOUND_ON = false;
  stopBgm();
 }
}

   if(      inkey == 38 || vkey == 38 ) { obj[0].d1 = 0; if( WALL[ chipNo(obj[0].x,obj[0].y-1) ] == 0 && chkObj(obj[0].d1) == -1 ) { obj[0].y --; plWalk = 1; } }
   else if( inkey == 40 || vkey == 40 ) { obj[0].d1 = 1; if( WALL[ chipNo(obj[0].x,obj[0].y+1) ] == 0 && chkObj(obj[0].d1) == -1 ) { obj[0].y ++; plWalk = 1; } }
   else if( inkey == 37 || vkey == 37 ) { obj[0].d1 = 2; if( WALL[ chipNo(obj[0].x-1,obj[0].y) ] == 0 && chkObj(obj[0].d1) == -1 ) { obj[0].x --; plWalk = 1; } }
   else if( inkey == 39 || vkey == 39 ) { obj[0].d1 = 3; if( WALL[ chipNo(obj[0].x+1,obj[0].y) ] == 0 && chkObj(obj[0].d1) == -1 ) { obj[0].x ++; plWalk = 1; } }
   else if( key[32] == 1 || vkey == 32 ) {//【制作中】調べる、メニューを開く
    objNum = chkObj(obj[0].d1);
    if( objNum >= 10 ) {//目の前にＮＰＣがいる
     obj[objNum].d1 = NPC_TALK_DIR[obj[0].d1];//プレイヤーの方に向かせる
     idx = IDX_TALK;
    }
    else {//何も無ければメニューを開く
     idx = IDX_MENU_TOP;
    }
   }
  }
  else {//移動中
   obj[0].cx = (obj[0].x-XP[obj[0].d1])*CHIP_SIZE + XP[obj[0].d1]*CHIP_SIZE*plWalk/PLWF;
   obj[0].cy = (obj[0].y-YP[obj[0].d1])*CHIP_SIZE + YP[obj[0].d1]*CHIP_SIZE*plWalk/PLWF;
   plWalk ++;
   if( plWalk >= PLWF ) plWalk = 0;
  }
  break;

  case IDX_CHANGE://マップ切り替え
  drawBG();
  drawObj();
  virtualKey();
  if( tmr == 1 ) {
   if( map_no == 0 ) { worldX = obj[0].x; worldY = obj[0].y; }
  }
  if( tmr <= 20 ) fRect( 0, 0, CHIP_SIZE*15, CHIP_SIZE*15, "rgba(0,0,0,"+0.05*tmr+")" );
  if( tmr >  20 ) fRect( 0, 0, CHIP_SIZE*15, CHIP_SIZE*15, "rgba(0,0,0,"+0.05*(40-tmr)+")" );
  if( tmr == 20 ) {
   if( map_no > 0 ) {//ワールドマップに戻る
    obj[0].x = worldX;
    obj[0].y = worldY+1;
    obj[0].d1 = 1;
    map_no = 0;
   }
   else {//町やダンジョンに入る
    map_no    = obj[objNum].d1;
    obj[0].x  = obj[objNum].d2;
    obj[0].y  = obj[objNum].d3;
    obj[0].d1 = obj[objNum].d4;
   }
   obj[0].cx = obj[0].x*CHIP_SIZE;
   obj[0].cy = obj[0].y*CHIP_SIZE;
   clrObj();
   setObj();
   setMap();
  }
  if( tmr == 40 ) idx = IDX_MOVE;
  break;

  case IDX_TALK://会話
  drawBG();
  drawObj();
  virtualKey();
  x = 360;
  y = 440;
  w = 680;
  h = 180;
  fRect( x-w/2, y-h/2, w, h, "rgba(0,0,0,0.5)" );
  sRect( x-w/2, y-h/2, w, h, "white" );
  fMessage( TALK_DATA[obj[objNum].d2], x-w/2+20, y-h/2+30, 60, 36, "white" );
  if( key[32] == 1 || vkey == 32 ) idx = 1;
  break;

  case IDX_MENU_TOP://メニュートップ画面
  drawBG();
  drawObj();
  virtualKey();
  escapeKey();
  x = 360;
  y = 320;
  w = 640;
  h = 360;
  fRect( x-w/2, y-h/2, w, h, "rgba(0,0,0,0.5)" );
  sRect( x-w/2, y-h/2, w, h, "white" );
  for( i = 0; i < 4; i ++ ) {
   var mx = i%2;
   var my = toInt(i/2);
   drawBtn( MENU_TOP[i], x+(mx*2-1)*120, y+(my*2-1)*80, 80, 60, 32, (i==selMenu)?"-cyan":"-silver", 10+i );
   if( btn_on[10+i] == 1 ) {
    if( selMenu == i ) {
     if( selMenu == 0 ) idx = IDX_MENU_STS;
    }
    else {
     selMenu = i;
    }
   }
  }
  //【制作中】仮のメニュー項目選択
//  if( inkey == 38 || vkey == 38 )
//  if( inkey == 40 || vkey == 40 )
  if( key[38] == 1 || btn_on[0] == 1 ) if( selMenu >= 2 ) selMenu -= 2;
  if( key[40] == 1 || btn_on[1] == 1 ) if( selMenu <= 1 ) selMenu += 2;

  if( inkey == 37 || vkey == 37 ) selMenu -= selMenu%2;
  if( inkey == 39 || vkey == 39 ) selMenu += (selMenu+1)%2;
  if( key[32] == 1 || vkey == 32 ) {
   if( selMenu == 0 ) idx = IDX_MENU_STS;
  }
  if( key[27] == 1 || btn_on[6] == 1 ) idx = IDX_MOVE;
  break;

  case IDX_MENU_STS://メニュー能力画面
  drawBG();
  drawObj();
  virtualKey();
  escapeKey();
  x = 360;
  y = 320;
  w = 640;
  h = 360;
  fRect( x-w/2, y-h/2, w, h, "rgba(0,0,0,0.5)" );
  sRect( x-w/2, y-h/2, w, h, "white" );
//【制作中】仮
  y -= h/2;
  y += 60;
  fText( "勇者", x-80, y, 32, "white" );
  y += 60;
  fText( "MH",  x-80, y, 32, "white" ); fText( sts[selChar].mh,  x+80, y, 32, "white" );
  y += 60;
  fText( "HP",  x-80, y, 32, "white" ); fText( sts[selChar].hp,  x+80, y, 32, "white" );
  y += 60;
  fText( "STR", x-80, y, 32, "white" ); fText( sts[selChar].str, x+80, y, 32, "white" );
  y += 60;
  fText( "DEF", x-80, y, 32, "white" ); fText( sts[selChar].def, x+80, y, 32, "white" );

//  if( key[37] == 1 || btn_on[2] == 1 ) { selChar --; if( selChar < 0 ) selChar = 2; }
//  if( key[39] == 1 || btn_on[3] == 1 ) { selChar ++; if( selChar > 2 ) selChar = 0; }
  if( key[27] == 1 || btn_on[6] == 1 ) idx = IDX_MENU_TOP;
  break;

 }

 fText( mapname, 100, 30, 24, "white" );
 fText( "X="+obj[0].x+" Y="+obj[0].y+" D="+obj[0].d1+" map_no="+map_no, 400, 30, 24, "white" );
 fText( ""+idx+":"+tmr, 100, 60, 24, "cyan" );
 fText( "inkey="+inkey+" vkey="+vkey, 400, 90, 24, "green" );
if( DBG_PRT ) {//★★★デバッグ
 fText( "CX="+obj[0].cx+" CY="+obj[0].cy+" plWalk="+plWalk, 400, 60, 24, "white" );
 fText( "bgmBak="+bgmBak+" BGM番号="+mapAtt[1], 400, 90, 24, "cyan" );
 fText( "key[32]="+key[32]+" btn_on[4]="+btn_on[4], 400, 150, 24, "pink" );
 if( plWalk == 0 ) fText( chkObj(), 680, 30, 24, "yellow" );
}

 //ブラウザのサイズが変化したか？（スマホなら持ち方を変えたか　縦持ち⇔横持ち）
 w = window.innerWidth;
 h = window.innerHeight;
 if( winW != w || winH != h ) {
  winW = w;
  winH = h;
  resizeCanvas();
 }

}

//【メモ】メイン処理と描画処理を分ける場合、描画処理をここに記載
function drawProc() {}
